%------------------------------------------------------------------------------
% File     : ITP195^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Sturm_Tarski problem prob_450__5874512_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Sturm_Tarski/prob_450__5874512_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v7.5.0
% Syntax   : Number of formulae    :  394 ( 114 unt;  54 typ;   0 def)
%            Number of atoms       : 1007 ( 247 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 3084 ( 121   ~;  28   |;  71   &;2354   @)
%                                         (   0 <=>; 510  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   7 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  112 ( 112   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   52 (  51 usr;   2 con; 0-3 aty)
%            Number of variables   :  912 (  46   ^; 778   !;  45   ?; 912   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:27:21.925
%------------------------------------------------------------------------------
% Could-be-implicit typings (5)
thf(ty_t_Polynomial_Opoly,type,
    poly: $tType > $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

% Explicit typings (49)
thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Ono__bot,type,
    no_bot: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Ono__top,type,
    no_top: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Ofield__char__0,type,
    field_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Odense__order,type,
    dense_order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__0,type,
    comm_semiring_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors,type,
    semiri1193490041visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__nonzero__semiring,type,
    linord1659791738miring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Conditionally__Complete__Lattices_Oconditionally__complete__linorder,type,
    condit1037483654norder: 
      !>[A: $tType] : $o ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Polynomial_Ois__zero,type,
    is_zero: 
      !>[A: $tType] : ( ( poly @ A ) > $o ) ).

thf(sy_c_Polynomial_Oorder,type,
    order2: 
      !>[A: $tType] : ( A > ( poly @ A ) > nat ) ).

thf(sy_c_Polynomial_Opderiv,type,
    pderiv: 
      !>[A: $tType] : ( ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Opoly,type,
    poly2: 
      !>[A: $tType] : ( ( poly @ A ) > A > A ) ).

thf(sy_c_Polynomial_Opoly_Ocoeff,type,
    coeff: 
      !>[A: $tType] : ( ( poly @ A ) > nat > A ) ).

thf(sy_c_Polynomial_Opoly__cutoff,type,
    poly_cutoff: 
      !>[A: $tType] : ( nat > ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Opoly__shift,type,
    poly_shift: 
      !>[A: $tType] : ( nat > ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Oreflect__poly,type,
    reflect_poly: 
      !>[A: $tType] : ( ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Orsquarefree,type,
    rsquarefree: 
      !>[A: $tType] : ( ( poly @ A ) > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Sturm__Tarski__Mirabelle__osyjafhhev_Ocross,type,
    sturm_424270202_cross: ( poly @ real ) > real > real > int ).

thf(sy_c_Sturm__Tarski__Mirabelle__osyjafhhev_Osign__r__pos,type,
    sturm_1700286437_r_pos: ( poly @ real ) > real > $o ).

thf(sy_c_Sturm__Tarski__Mirabelle__osyjafhhev_Ovariation,type,
    sturm_1771227917iation: real > real > int ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_p,type,
    p: poly @ real ).

thf(sy_v_x,type,
    x: real ).

% Relevant facts (252)
thf(fact_0_False,axiom,
    ( ( poly2 @ real @ p @ x )
   != ( zero_zero @ real ) ) ).

% False
thf(fact_1__092_060open_062sign__r__pos_Ap_Ax_A_092_060Longrightarrow_062_A0_A_060_Apoly_Ap_Ax_092_060close_062,axiom,
    ( ( sturm_1700286437_r_pos @ p @ x )
   => ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ p @ x ) ) ) ).

% \<open>sign_r_pos p x \<Longrightarrow> 0 < poly p x\<close>
thf(fact_2__092_060open_0620_A_060_Apoly_Ap_Ax_A_092_060Longrightarrow_062_Asign__r__pos_Ap_Ax_092_060close_062,axiom,
    ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ p @ x ) )
   => ( sturm_1700286437_r_pos @ p @ x ) ) ).

% \<open>0 < poly p x \<Longrightarrow> sign_r_pos p x\<close>
thf(fact_3_assms,axiom,
    ( p
   != ( zero_zero @ ( poly @ real ) ) ) ).

% assms
thf(fact_4_poly__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [X: A] :
          ( ( poly2 @ A @ ( zero_zero @ ( poly @ A ) ) @ X )
          = ( zero_zero @ A ) ) ) ).

% poly_0
thf(fact_5_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_6_poly__IVT__neg,axiom,
    ! [A2: real,B: real,P: poly @ real] :
      ( ( ord_less @ real @ A2 @ B )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ A2 ) )
       => ( ( ord_less @ real @ ( poly2 @ real @ P @ B ) @ ( zero_zero @ real ) )
         => ? [X2: real] :
              ( ( ord_less @ real @ A2 @ X2 )
              & ( ord_less @ real @ X2 @ B )
              & ( ( poly2 @ real @ P @ X2 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_neg
thf(fact_7_poly__IVT__pos,axiom,
    ! [A2: real,B: real,P: poly @ real] :
      ( ( ord_less @ real @ A2 @ B )
     => ( ( ord_less @ real @ ( poly2 @ real @ P @ A2 ) @ ( zero_zero @ real ) )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ B ) )
         => ? [X2: real] :
              ( ( ord_less @ real @ A2 @ X2 )
              & ( ord_less @ real @ X2 @ B )
              & ( ( poly2 @ real @ P @ X2 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_pos
thf(fact_8_poly__all__0__iff__0,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A] :
          ( ( ! [X3: A] :
                ( ( poly2 @ A @ P @ X3 )
                = ( zero_zero @ A ) ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% poly_all_0_iff_0
thf(fact_9_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_10_field__lbound__gt__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [D1: A,D2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ D1 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ D2 )
           => ? [E: A] :
                ( ( ord_less @ A @ ( zero_zero @ A ) @ E )
                & ( ord_less @ A @ E @ D1 )
                & ( ord_less @ A @ E @ D2 ) ) ) ) ) ).

% field_lbound_gt_zero
thf(fact_11_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_12_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_13_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_14_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_15_pderiv__0,axiom,
    ! [A: $tType] :
      ( ( ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ( ( pderiv @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( zero_zero @ ( poly @ A ) ) ) ) ).

% pderiv_0
thf(fact_16_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_17_poly__eq__poly__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A,Q: poly @ A] :
          ( ( ( poly2 @ A @ P )
            = ( poly2 @ A @ Q ) )
          = ( P = Q ) ) ) ).

% poly_eq_poly_eq_iff
thf(fact_18_cross__0,axiom,
    ! [A2: real,B: real] :
      ( ( sturm_424270202_cross @ ( zero_zero @ ( poly @ real ) ) @ A2 @ B )
      = ( zero_zero @ int ) ) ).

% cross_0
thf(fact_19_rsquarefree__roots,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ( ( rsquarefree @ A )
        = ( ^ [P2: poly @ A] :
            ! [A3: A] :
              ~ ( ( ( poly2 @ A @ P2 @ A3 )
                  = ( zero_zero @ A ) )
                & ( ( poly2 @ A @ ( pderiv @ A @ P2 ) @ A3 )
                  = ( zero_zero @ A ) ) ) ) ) ) ).

% rsquarefree_roots
thf(fact_20_cross__no__root,axiom,
    ! [A2: real,B: real,P: poly @ real] :
      ( ( ord_less @ real @ A2 @ B )
     => ( ! [X2: real] :
            ( ( ( ord_less @ real @ A2 @ X2 )
              & ( ord_less @ real @ X2 @ B ) )
           => ( ( poly2 @ real @ P @ X2 )
             != ( zero_zero @ real ) ) )
       => ( ( sturm_424270202_cross @ P @ A2 @ B )
          = ( zero_zero @ int ) ) ) ) ).

% cross_no_root
thf(fact_21_is__zero__null,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( is_zero @ A )
        = ( ^ [P2: poly @ A] :
              ( P2
              = ( zero_zero @ ( poly @ A ) ) ) ) ) ) ).

% is_zero_null
thf(fact_22_poly__cutoff__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( poly_cutoff @ A @ N @ ( zero_zero @ ( poly @ A ) ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% poly_cutoff_0
thf(fact_23_reflect__poly__at__0__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P: poly @ A] :
          ( ( ( poly2 @ A @ ( reflect_poly @ A @ P ) @ ( zero_zero @ A ) )
            = ( zero_zero @ A ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_24_next__non__root__interval,axiom,
    ! [P: poly @ real,Lb: real] :
      ( ( P
       != ( zero_zero @ ( poly @ real ) ) )
     => ~ ! [Ub: real] :
            ( ( ord_less @ real @ Lb @ Ub )
           => ~ ! [Z: real] :
                  ( ( ( ord_less @ real @ Lb @ Z )
                    & ( ord_less_eq @ real @ Z @ Ub ) )
                 => ( ( poly2 @ real @ P @ Z )
                   != ( zero_zero @ real ) ) ) ) ) ).

% next_non_root_interval
thf(fact_25_last__non__root__interval,axiom,
    ! [P: poly @ real,Ub2: real] :
      ( ( P
       != ( zero_zero @ ( poly @ real ) ) )
     => ~ ! [Lb2: real] :
            ( ( ord_less @ real @ Lb2 @ Ub2 )
           => ~ ! [Z: real] :
                  ( ( ( ord_less_eq @ real @ Lb2 @ Z )
                    & ( ord_less @ real @ Z @ Ub2 ) )
                 => ( ( poly2 @ real @ P @ Z )
                   != ( zero_zero @ real ) ) ) ) ) ).

% last_non_root_interval
thf(fact_26_poly__shift__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( poly_shift @ A @ N @ ( zero_zero @ ( poly @ A ) ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% poly_shift_0
thf(fact_27_order__root,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ! [P: poly @ A,A2: A] :
          ( ( ( poly2 @ A @ P @ A2 )
            = ( zero_zero @ A ) )
          = ( ( P
              = ( zero_zero @ ( poly @ A ) ) )
            | ( ( order2 @ A @ A2 @ P )
             != ( zero_zero @ nat ) ) ) ) ) ).

% order_root
thf(fact_28_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_29_reflect__poly__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( reflect_poly @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( zero_zero @ ( poly @ A ) ) ) ) ).

% reflect_poly_0
thf(fact_30_poly__shift__id,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( poly_shift @ A @ ( zero_zero @ nat ) )
        = ( ^ [X3: poly @ A] : X3 ) ) ) ).

% poly_shift_id
thf(fact_31_complete__real,axiom,
    ! [S: set @ real] :
      ( ? [X4: real] : ( member @ real @ X4 @ S )
     => ( ? [Z: real] :
          ! [X2: real] :
            ( ( member @ real @ X2 @ S )
           => ( ord_less_eq @ real @ X2 @ Z ) )
       => ? [Y: real] :
            ( ! [X4: real] :
                ( ( member @ real @ X4 @ S )
               => ( ord_less_eq @ real @ X4 @ Y ) )
            & ! [Z: real] :
                ( ! [X2: real] :
                    ( ( member @ real @ X2 @ S )
                   => ( ord_less_eq @ real @ X2 @ Z ) )
               => ( ord_less_eq @ real @ Y @ Z ) ) ) ) ) ).

% complete_real
thf(fact_32_le__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% le_numeral_extra(3)
thf(fact_33_zero__le,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ X ) ) ).

% zero_le
thf(fact_34_less__eq__real__def,axiom,
    ( ( ord_less_eq @ real )
    = ( ^ [X3: real,Y2: real] :
          ( ( ord_less @ real @ X3 @ Y2 )
          | ( X3 = Y2 ) ) ) ) ).

% less_eq_real_def
thf(fact_35_order__0I,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ! [P: poly @ A,A2: A] :
          ( ( ( poly2 @ A @ P @ A2 )
           != ( zero_zero @ A ) )
         => ( ( order2 @ A @ A2 @ P )
            = ( zero_zero @ nat ) ) ) ) ).

% order_0I
thf(fact_36_not__eq__pos__or__neg__iff__1,axiom,
    ! [Lb: real,Ub2: real,P: poly @ real] :
      ( ( ! [Z2: real] :
            ( ( ( ord_less @ real @ Lb @ Z2 )
              & ( ord_less_eq @ real @ Z2 @ Ub2 ) )
           => ( ( poly2 @ real @ P @ Z2 )
             != ( zero_zero @ real ) ) ) )
      = ( ! [Z2: real] :
            ( ( ( ord_less @ real @ Lb @ Z2 )
              & ( ord_less_eq @ real @ Z2 @ Ub2 ) )
           => ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ Z2 ) ) )
        | ! [Z2: real] :
            ( ( ( ord_less @ real @ Lb @ Z2 )
              & ( ord_less_eq @ real @ Z2 @ Ub2 ) )
           => ( ord_less @ real @ ( poly2 @ real @ P @ Z2 ) @ ( zero_zero @ real ) ) ) ) ) ).

% not_eq_pos_or_neg_iff_1
thf(fact_37_not__eq__pos__or__neg__iff__2,axiom,
    ! [Lb: real,Ub2: real,P: poly @ real] :
      ( ( ! [Z2: real] :
            ( ( ( ord_less_eq @ real @ Lb @ Z2 )
              & ( ord_less @ real @ Z2 @ Ub2 ) )
           => ( ( poly2 @ real @ P @ Z2 )
             != ( zero_zero @ real ) ) ) )
      = ( ! [Z2: real] :
            ( ( ( ord_less_eq @ real @ Lb @ Z2 )
              & ( ord_less @ real @ Z2 @ Ub2 ) )
           => ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ Z2 ) ) )
        | ! [Z2: real] :
            ( ( ( ord_less_eq @ real @ Lb @ Z2 )
              & ( ord_less @ real @ Z2 @ Ub2 ) )
           => ( ord_less @ real @ ( poly2 @ real @ P @ Z2 ) @ ( zero_zero @ real ) ) ) ) ) ).

% not_eq_pos_or_neg_iff_2
thf(fact_38_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_39_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_nat_zero_code
thf(fact_40_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A2: nat] :
      ( ( A2
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ A2 ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_41_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_42_minf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ X4 @ Z3 )
         => ~ ( ord_less_eq @ A @ T @ X4 ) ) ) ).

% minf(8)
thf(fact_43_minf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ X4 @ Z3 )
         => ( ord_less_eq @ A @ X4 @ T ) ) ) ).

% minf(6)
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P3: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P3 ) )
      = ( P3 @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X3: A] : ( member @ A @ X3 @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P3: A > $o,Q2: A > $o] :
      ( ! [X2: A] :
          ( ( P3 @ X2 )
          = ( Q2 @ X2 ) )
     => ( ( collect @ A @ P3 )
        = ( collect @ A @ Q2 ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B2: $tType,A: $tType,F: A > B2,G: A > B2] :
      ( ! [X2: A] :
          ( ( F @ X2 )
          = ( G @ X2 ) )
     => ( F = G ) ) ).

% ext
thf(fact_48_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ Z3 @ X4 )
         => ( ord_less_eq @ A @ T @ X4 ) ) ) ).

% pinf(8)
thf(fact_49_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ Z3 @ X4 )
         => ~ ( ord_less_eq @ A @ X4 @ T ) ) ) ).

% pinf(6)
thf(fact_50_verit__comp__simplify1_I3_J,axiom,
    ! [B2: $tType] :
      ( ( linorder @ B2 )
     => ! [B3: B2,A5: B2] :
          ( ( ~ ( ord_less_eq @ B2 @ B3 @ A5 ) )
          = ( ord_less @ B2 @ A5 @ B3 ) ) ) ).

% verit_comp_simplify1(3)
thf(fact_51_bot__nat__0_Oextremum,axiom,
    ! [A2: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ A2 ) ).

% bot_nat_0.extremum
thf(fact_52_le0,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% le0
thf(fact_53_nat__less__le,axiom,
    ( ( ord_less @ nat )
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less_eq @ nat @ M2 @ N2 )
          & ( M2 != N2 ) ) ) ) ).

% nat_less_le
thf(fact_54_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_55_le__eq__less__or__eq,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less @ nat @ M2 @ N2 )
          | ( M2 = N2 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_56_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less @ nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_57_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( M != N )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_58_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I: nat,J: nat] :
      ( ! [I2: nat,J2: nat] :
          ( ( ord_less @ nat @ I2 @ J2 )
         => ( ord_less @ nat @ ( F @ I2 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq @ nat @ I @ J )
       => ( ord_less_eq @ nat @ ( F @ I ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_59_infinite__descent__measure,axiom,
    ! [A: $tType,P3: A > $o,V: A > nat,X: A] :
      ( ! [X2: A] :
          ( ~ ( P3 @ X2 )
         => ? [Y3: A] :
              ( ( ord_less @ nat @ ( V @ Y3 ) @ ( V @ X2 ) )
              & ~ ( P3 @ Y3 ) ) )
     => ( P3 @ X ) ) ).

% infinite_descent_measure
thf(fact_60_linorder__neqE__nat,axiom,
    ! [X: nat,Y4: nat] :
      ( ( X != Y4 )
     => ( ~ ( ord_less @ nat @ X @ Y4 )
       => ( ord_less @ nat @ Y4 @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_61_infinite__descent,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ~ ( P3 @ N3 )
         => ? [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N3 )
              & ~ ( P3 @ M3 ) ) )
     => ( P3 @ N ) ) ).

% infinite_descent
thf(fact_62_nat__less__induct,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N3 )
             => ( P3 @ M3 ) )
         => ( P3 @ N3 ) )
     => ( P3 @ N ) ) ).

% nat_less_induct
thf(fact_63_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_64_less__not__refl3,axiom,
    ! [S2: nat,T: nat] :
      ( ( ord_less @ nat @ S2 @ T )
     => ( S2 != T ) ) ).

% less_not_refl3
thf(fact_65_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_66_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_67_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_68_bot__nat__0_Oextremum__uniqueI,axiom,
    ! [A2: nat] :
      ( ( ord_less_eq @ nat @ A2 @ ( zero_zero @ nat ) )
     => ( A2
        = ( zero_zero @ nat ) ) ) ).

% bot_nat_0.extremum_uniqueI
thf(fact_69_bot__nat__0_Oextremum__unique,axiom,
    ! [A2: nat] :
      ( ( ord_less_eq @ nat @ A2 @ ( zero_zero @ nat ) )
      = ( A2
        = ( zero_zero @ nat ) ) ) ).

% bot_nat_0.extremum_unique
thf(fact_70_ex__least__nat__le,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ( P3 @ N )
     => ( ~ ( P3 @ ( zero_zero @ nat ) )
       => ? [K: nat] :
            ( ( ord_less_eq @ nat @ K @ N )
            & ! [I3: nat] :
                ( ( ord_less @ nat @ I3 @ K )
               => ~ ( P3 @ I3 ) )
            & ( P3 @ K ) ) ) ) ).

% ex_least_nat_le
thf(fact_71_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq @ nat @ N @ ( zero_zero @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% le_0_eq
thf(fact_72_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% less_eq_nat.simps(1)
thf(fact_73_conj__le__cong,axiom,
    ! [X: int,X5: int,P3: $o,P4: $o] :
      ( ( X = X5 )
     => ( ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X5 )
         => ( P3 = P4 ) )
       => ( ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X )
            & P3 )
          = ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X5 )
            & P4 ) ) ) ) ).

% conj_le_cong
thf(fact_74_imp__le__cong,axiom,
    ! [X: int,X5: int,P3: $o,P4: $o] :
      ( ( X = X5 )
     => ( ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X5 )
         => ( P3 = P4 ) )
       => ( ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X )
           => P3 )
          = ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ X5 )
           => P4 ) ) ) ) ).

% imp_le_cong
thf(fact_75_le__funD,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 )
     => ! [F: A > B2,G: A > B2,X: A] :
          ( ( ord_less_eq @ ( A > B2 ) @ F @ G )
         => ( ord_less_eq @ B2 @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funD
thf(fact_76_le__funE,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 )
     => ! [F: A > B2,G: A > B2,X: A] :
          ( ( ord_less_eq @ ( A > B2 ) @ F @ G )
         => ( ord_less_eq @ B2 @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funE
thf(fact_77_le__funI,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 )
     => ! [F: A > B2,G: A > B2] :
          ( ! [X2: A] : ( ord_less_eq @ B2 @ ( F @ X2 ) @ ( G @ X2 ) )
         => ( ord_less_eq @ ( A > B2 ) @ F @ G ) ) ) ).

% le_funI
thf(fact_78_le__fun__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 )
     => ( ( ord_less_eq @ ( A > B2 ) )
        = ( ^ [F2: A > B2,G2: A > B2] :
            ! [X3: A] : ( ord_less_eq @ B2 @ ( F2 @ X3 ) @ ( G2 @ X3 ) ) ) ) ) ).

% le_fun_def
thf(fact_79_order__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 )
        & ( order @ A ) )
     => ! [A2: A,F: B2 > A,B: B2,C: B2] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less_eq @ B2 @ B @ C )
           => ( ! [X2: B2,Y: B2] :
                  ( ( ord_less_eq @ B2 @ X2 @ Y )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_80_order__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 )
        & ( order @ A ) )
     => ! [A2: A,B: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ C2 @ ( F @ B ) @ C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y )
                 => ( ord_less_eq @ C2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_81_verit__la__disequality,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] :
          ( ( A2 = B )
          | ~ ( ord_less_eq @ A @ A2 @ B )
          | ~ ( ord_less_eq @ A @ B @ A2 ) ) ) ).

% verit_la_disequality
thf(fact_82_ord__eq__le__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 )
        & ( ord @ A ) )
     => ! [A2: A,F: B2 > A,B: B2,C: B2] :
          ( ( A2
            = ( F @ B ) )
         => ( ( ord_less_eq @ B2 @ B @ C )
           => ( ! [X2: B2,Y: B2] :
                  ( ( ord_less_eq @ B2 @ X2 @ Y )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_83_ord__le__eq__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 )
        & ( ord @ A ) )
     => ! [A2: A,B: A,F: A > B2,C: B2] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ( F @ B )
              = C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y )
                 => ( ord_less_eq @ B2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ B2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_84_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y5: A,Z4: A] : ( Y5 = Z4 ) )
        = ( ^ [X3: A,Y2: A] :
              ( ( ord_less_eq @ A @ X3 @ Y2 )
              & ( ord_less_eq @ A @ Y2 @ X3 ) ) ) ) ) ).

% eq_iff
thf(fact_85_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ X )
           => ( X = Y4 ) ) ) ) ).

% antisym
thf(fact_86_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
          | ( ord_less_eq @ A @ Y4 @ X ) ) ) ).

% linear
thf(fact_87_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A] :
          ( ( X = Y4 )
         => ( ord_less_eq @ A @ X @ Y4 ) ) ) ).

% eq_refl
thf(fact_88_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y4 )
         => ( ord_less_eq @ A @ Y4 @ X ) ) ) ).

% le_cases
thf(fact_89_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% order.trans
thf(fact_90_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A,Z5: A] :
          ( ( ( ord_less_eq @ A @ X @ Y4 )
           => ~ ( ord_less_eq @ A @ Y4 @ Z5 ) )
         => ( ( ( ord_less_eq @ A @ Y4 @ X )
             => ~ ( ord_less_eq @ A @ X @ Z5 ) )
           => ( ( ( ord_less_eq @ A @ X @ Z5 )
               => ~ ( ord_less_eq @ A @ Z5 @ Y4 ) )
             => ( ( ( ord_less_eq @ A @ Z5 @ Y4 )
                 => ~ ( ord_less_eq @ A @ Y4 @ X ) )
               => ( ( ( ord_less_eq @ A @ Y4 @ Z5 )
                   => ~ ( ord_less_eq @ A @ Z5 @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z5 @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y4 ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_91_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y4: A,X: A] :
          ( ( ord_less_eq @ A @ Y4 @ X )
         => ( ( ord_less_eq @ A @ X @ Y4 )
            = ( X = Y4 ) ) ) ) ).

% antisym_conv
thf(fact_92_order__class_Oorder_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y5: A,Z4: A] : ( Y5 = Z4 ) )
        = ( ^ [A3: A,B4: A] :
              ( ( ord_less_eq @ A @ A3 @ B4 )
              & ( ord_less_eq @ A @ B4 @ A3 ) ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_93_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( A2 = B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_94_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( B = C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_95_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ A2 )
           => ( A2 = B ) ) ) ) ).

% order_class.order.antisym
thf(fact_96_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A,Z5: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ Z5 )
           => ( ord_less_eq @ A @ X @ Z5 ) ) ) ) ).

% order_trans
thf(fact_97_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_98_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > A > $o,A2: A,B: A] :
          ( ! [A6: A,B5: A] :
              ( ( ord_less_eq @ A @ A6 @ B5 )
             => ( P3 @ A6 @ B5 ) )
         => ( ! [A6: A,B5: A] :
                ( ( P3 @ B5 @ A6 )
               => ( P3 @ A6 @ B5 ) )
           => ( P3 @ A2 @ B ) ) ) ) ).

% linorder_wlog
thf(fact_99_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ B )
           => ( ord_less_eq @ A @ C @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_100_dual__order_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y5: A,Z4: A] : ( Y5 = Z4 ) )
        = ( ^ [A3: A,B4: A] :
              ( ( ord_less_eq @ A @ B4 @ A3 )
              & ( ord_less_eq @ A @ A3 @ B4 ) ) ) ) ) ).

% dual_order.eq_iff
thf(fact_101_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B )
           => ( A2 = B ) ) ) ) ).

% dual_order.antisym
thf(fact_102_dual__order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( A2 != B ) ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_103_order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( A2 != B ) ) ) ).

% order.strict_implies_not_eq
thf(fact_104_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ~ ( ord_less @ A @ X @ Y4 ) )
          = ( ( ord_less @ A @ Y4 @ X )
            | ( X = Y4 ) ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_105_dual__order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ( ord_less @ A @ C @ B )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans
thf(fact_106_linorder__less__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > A > $o,A2: A,B: A] :
          ( ! [A6: A,B5: A] :
              ( ( ord_less @ A @ A6 @ B5 )
             => ( P3 @ A6 @ B5 ) )
         => ( ! [A6: A] : ( P3 @ A6 @ A6 )
           => ( ! [A6: A,B5: A] :
                  ( ( P3 @ B5 @ A6 )
                 => ( P3 @ A6 @ B5 ) )
             => ( P3 @ A2 @ B ) ) ) ) ) ).

% linorder_less_wlog
thf(fact_107_exists__least__iff,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A )
     => ( ( ^ [P5: A > $o] :
            ? [X6: A] : ( P5 @ X6 ) )
        = ( ^ [P6: A > $o] :
            ? [N2: A] :
              ( ( P6 @ N2 )
              & ! [M2: A] :
                  ( ( ord_less @ A @ M2 @ N2 )
                 => ~ ( P6 @ M2 ) ) ) ) ) ) ).

% exists_least_iff
thf(fact_108_less__imp__not__less,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ~ ( ord_less @ A @ Y4 @ X ) ) ) ).

% less_imp_not_less
thf(fact_109_order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less @ A @ B @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans
thf(fact_110_dual__order_Oirrefl,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] :
          ~ ( ord_less @ A @ A2 @ A2 ) ) ).

% dual_order.irrefl
thf(fact_111_linorder__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ~ ( ord_less @ A @ X @ Y4 )
         => ( ( X != Y4 )
           => ( ord_less @ A @ Y4 @ X ) ) ) ) ).

% linorder_cases
thf(fact_112_less__imp__triv,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A,P3: $o] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ( ord_less @ A @ Y4 @ X )
           => P3 ) ) ) ).

% less_imp_triv
thf(fact_113_less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( Y4 != X ) ) ) ).

% less_imp_not_eq2
thf(fact_114_antisym__conv3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Y4: A,X: A] :
          ( ~ ( ord_less @ A @ Y4 @ X )
         => ( ( ~ ( ord_less @ A @ X @ Y4 ) )
            = ( X = Y4 ) ) ) ) ).

% antisym_conv3
thf(fact_115_less__induct,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A )
     => ! [P3: A > $o,A2: A] :
          ( ! [X2: A] :
              ( ! [Y3: A] :
                  ( ( ord_less @ A @ Y3 @ X2 )
                 => ( P3 @ Y3 ) )
             => ( P3 @ X2 ) )
         => ( P3 @ A2 ) ) ) ).

% less_induct
thf(fact_116_less__not__sym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ~ ( ord_less @ A @ Y4 @ X ) ) ) ).

% less_not_sym
thf(fact_117_less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( X != Y4 ) ) ) ).

% less_imp_not_eq
thf(fact_118_dual__order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ~ ( ord_less @ A @ A2 @ B ) ) ) ).

% dual_order.asym
thf(fact_119_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( B = C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% ord_less_eq_trans
thf(fact_120_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( A2 = B )
         => ( ( ord_less @ A @ B @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% ord_eq_less_trans
thf(fact_121_less__irrefl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A] :
          ~ ( ord_less @ A @ X @ X ) ) ).

% less_irrefl
thf(fact_122_less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
          | ( X = Y4 )
          | ( ord_less @ A @ Y4 @ X ) ) ) ).

% less_linear
thf(fact_123_less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A,Z5: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ( ord_less @ A @ Y4 @ Z5 )
           => ( ord_less @ A @ X @ Z5 ) ) ) ) ).

% less_trans
thf(fact_124_less__asym_H,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ~ ( ord_less @ A @ B @ A2 ) ) ) ).

% less_asym'
thf(fact_125_less__asym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ~ ( ord_less @ A @ Y4 @ X ) ) ) ).

% less_asym
thf(fact_126_less__imp__neq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( X != Y4 ) ) ) ).

% less_imp_neq
thf(fact_127_dense,axiom,
    ! [A: $tType] :
      ( ( dense_order @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ? [Z3: A] :
              ( ( ord_less @ A @ X @ Z3 )
              & ( ord_less @ A @ Z3 @ Y4 ) ) ) ) ).

% dense
thf(fact_128_order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ~ ( ord_less @ A @ B @ A2 ) ) ) ).

% order.asym
thf(fact_129_neq__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ( X != Y4 )
          = ( ( ord_less @ A @ X @ Y4 )
            | ( ord_less @ A @ Y4 @ X ) ) ) ) ).

% neq_iff
thf(fact_130_neqE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ( X != Y4 )
         => ( ~ ( ord_less @ A @ X @ Y4 )
           => ( ord_less @ A @ Y4 @ X ) ) ) ) ).

% neqE
thf(fact_131_gt__ex,axiom,
    ! [A: $tType] :
      ( ( no_top @ A )
     => ! [X: A] :
        ? [X_1: A] : ( ord_less @ A @ X @ X_1 ) ) ).

% gt_ex
thf(fact_132_lt__ex,axiom,
    ! [A: $tType] :
      ( ( no_bot @ A )
     => ! [X: A] :
        ? [Y: A] : ( ord_less @ A @ Y @ X ) ) ).

% lt_ex
thf(fact_133_order__less__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 )
        & ( order @ A ) )
     => ! [A2: A,B: A,F: A > C2,C: C2] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less @ C2 @ ( F @ B ) @ C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less @ A @ X2 @ Y )
                 => ( ord_less @ C2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_less_subst2
thf(fact_134_order__less__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 )
        & ( order @ A ) )
     => ! [A2: A,F: B2 > A,B: B2,C: B2] :
          ( ( ord_less @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less @ B2 @ B @ C )
           => ( ! [X2: B2,Y: B2] :
                  ( ( ord_less @ B2 @ X2 @ Y )
                 => ( ord_less @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_less_subst1
thf(fact_135_ord__less__eq__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 )
        & ( ord @ A ) )
     => ! [A2: A,B: A,F: A > B2,C: B2] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ( F @ B )
              = C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less @ A @ X2 @ Y )
                 => ( ord_less @ B2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ B2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_less_eq_subst
thf(fact_136_ord__eq__less__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 )
        & ( ord @ A ) )
     => ! [A2: A,F: B2 > A,B: B2,C: B2] :
          ( ( A2
            = ( F @ B ) )
         => ( ( ord_less @ B2 @ B @ C )
           => ( ! [X2: B2,Y: B2] :
                  ( ( ord_less @ B2 @ X2 @ Y )
                 => ( ord_less @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_137_measure__induct__rule,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( wellorder @ B2 )
     => ! [F: A > B2,P3: A > $o,A2: A] :
          ( ! [X2: A] :
              ( ! [Y3: A] :
                  ( ( ord_less @ B2 @ ( F @ Y3 ) @ ( F @ X2 ) )
                 => ( P3 @ Y3 ) )
             => ( P3 @ X2 ) )
         => ( P3 @ A2 ) ) ) ).

% measure_induct_rule
thf(fact_138_measure__induct,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( wellorder @ B2 )
     => ! [F: A > B2,P3: A > $o,A2: A] :
          ( ! [X2: A] :
              ( ! [Y3: A] :
                  ( ( ord_less @ B2 @ ( F @ Y3 ) @ ( F @ X2 ) )
                 => ( P3 @ Y3 ) )
             => ( P3 @ X2 ) )
         => ( P3 @ A2 ) ) ) ).

% measure_induct
thf(fact_139_verit__comp__simplify1_I1_J,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] :
          ~ ( ord_less @ A @ A2 @ A2 ) ) ).

% verit_comp_simplify1(1)
thf(fact_140_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > $o,P4: A > $o,Q2: A > $o,Q3: A > $o] :
          ( ? [Z: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ Z @ X2 )
             => ( ( P3 @ X2 )
                = ( P4 @ X2 ) ) )
         => ( ? [Z: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ Z @ X2 )
               => ( ( Q2 @ X2 )
                  = ( Q3 @ X2 ) ) )
           => ? [Z3: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z3 @ X4 )
               => ( ( ( P3 @ X4 )
                    & ( Q2 @ X4 ) )
                  = ( ( P4 @ X4 )
                    & ( Q3 @ X4 ) ) ) ) ) ) ) ).

% pinf(1)
thf(fact_141_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > $o,P4: A > $o,Q2: A > $o,Q3: A > $o] :
          ( ? [Z: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ Z @ X2 )
             => ( ( P3 @ X2 )
                = ( P4 @ X2 ) ) )
         => ( ? [Z: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ Z @ X2 )
               => ( ( Q2 @ X2 )
                  = ( Q3 @ X2 ) ) )
           => ? [Z3: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z3 @ X4 )
               => ( ( ( P3 @ X4 )
                    | ( Q2 @ X4 ) )
                  = ( ( P4 @ X4 )
                    | ( Q3 @ X4 ) ) ) ) ) ) ) ).

% pinf(2)
thf(fact_142_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ Z3 @ X4 )
         => ( X4 != T ) ) ) ).

% pinf(3)
thf(fact_143_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ Z3 @ X4 )
         => ( X4 != T ) ) ) ).

% pinf(4)
thf(fact_144_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ Z3 @ X4 )
         => ~ ( ord_less @ A @ X4 @ T ) ) ) ).

% pinf(5)
thf(fact_145_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ Z3 @ X4 )
         => ( ord_less @ A @ T @ X4 ) ) ) ).

% pinf(7)
thf(fact_146_pinf_I11_J,axiom,
    ! [C2: $tType,D: $tType] :
      ( ( ord @ C2 )
     => ! [F3: D] :
        ? [Z3: C2] :
        ! [X4: C2] :
          ( ( ord_less @ C2 @ Z3 @ X4 )
         => ( F3 = F3 ) ) ) ).

% pinf(11)
thf(fact_147_minf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > $o,P4: A > $o,Q2: A > $o,Q3: A > $o] :
          ( ? [Z: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Z )
             => ( ( P3 @ X2 )
                = ( P4 @ X2 ) ) )
         => ( ? [Z: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ X2 @ Z )
               => ( ( Q2 @ X2 )
                  = ( Q3 @ X2 ) ) )
           => ? [Z3: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z3 )
               => ( ( ( P3 @ X4 )
                    & ( Q2 @ X4 ) )
                  = ( ( P4 @ X4 )
                    & ( Q3 @ X4 ) ) ) ) ) ) ) ).

% minf(1)
thf(fact_148_minf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > $o,P4: A > $o,Q2: A > $o,Q3: A > $o] :
          ( ? [Z: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Z )
             => ( ( P3 @ X2 )
                = ( P4 @ X2 ) ) )
         => ( ? [Z: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ X2 @ Z )
               => ( ( Q2 @ X2 )
                  = ( Q3 @ X2 ) ) )
           => ? [Z3: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z3 )
               => ( ( ( P3 @ X4 )
                    | ( Q2 @ X4 ) )
                  = ( ( P4 @ X4 )
                    | ( Q3 @ X4 ) ) ) ) ) ) ) ).

% minf(2)
thf(fact_149_minf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ X4 @ Z3 )
         => ( X4 != T ) ) ) ).

% minf(3)
thf(fact_150_minf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ X4 @ Z3 )
         => ( X4 != T ) ) ) ).

% minf(4)
thf(fact_151_minf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ X4 @ Z3 )
         => ( ord_less @ A @ X4 @ T ) ) ) ).

% minf(5)
thf(fact_152_minf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X4: A] :
          ( ( ord_less @ A @ X4 @ Z3 )
         => ~ ( ord_less @ A @ T @ X4 ) ) ) ).

% minf(7)
thf(fact_153_minf_I11_J,axiom,
    ! [C2: $tType,D: $tType] :
      ( ( ord @ C2 )
     => ! [F3: D] :
        ? [Z3: C2] :
        ! [X4: C2] :
          ( ( ord_less @ C2 @ X4 @ Z3 )
         => ( F3 = F3 ) ) ) ).

% minf(11)
thf(fact_154_infinite__descent0__measure,axiom,
    ! [A: $tType,V: A > nat,P3: A > $o,X: A] :
      ( ! [X2: A] :
          ( ( ( V @ X2 )
            = ( zero_zero @ nat ) )
         => ( P3 @ X2 ) )
     => ( ! [X2: A] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( V @ X2 ) )
           => ( ~ ( P3 @ X2 )
             => ? [Y3: A] :
                  ( ( ord_less @ nat @ ( V @ Y3 ) @ ( V @ X2 ) )
                  & ~ ( P3 @ Y3 ) ) ) )
       => ( P3 @ X ) ) ) ).

% infinite_descent0_measure
thf(fact_155_bot__nat__0_Oextremum__strict,axiom,
    ! [A2: nat] :
      ~ ( ord_less @ nat @ A2 @ ( zero_zero @ nat ) ) ).

% bot_nat_0.extremum_strict
thf(fact_156_infinite__descent0,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ( P3 @ ( zero_zero @ nat ) )
     => ( ! [N3: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 )
           => ( ~ ( P3 @ N3 )
             => ? [M3: nat] :
                  ( ( ord_less @ nat @ M3 @ N3 )
                  & ~ ( P3 @ M3 ) ) ) )
       => ( P3 @ N ) ) ) ).

% infinite_descent0
thf(fact_157_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( N
       != ( zero_zero @ nat ) ) ) ).

% gr_implies_not0
thf(fact_158_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_zeroE
thf(fact_159_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% not_less0
thf(fact_160_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% not_gr0
thf(fact_161_gr0I,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% gr0I
thf(fact_162_order_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( A2 != B )
         => ( ( ord_less_eq @ A @ A2 @ B )
           => ( ord_less @ A @ A2 @ B ) ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_163_dual__order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ord_less_eq @ A @ B @ A2 ) ) ) ).

% dual_order.strict_implies_order
thf(fact_164_dual__order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [B4: A,A3: A] :
              ( ( ord_less_eq @ A @ B4 @ A3 )
              & ( A3 != B4 ) ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_165_dual__order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [B4: A,A3: A] :
              ( ( ord_less @ A @ B4 @ A3 )
              | ( A3 = B4 ) ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_166_order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% order.strict_implies_order
thf(fact_167_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [X: A,Y4: A,Z5: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ! [W: A] :
                ( ( ord_less @ A @ X @ W )
               => ( ( ord_less @ A @ W @ Y4 )
                 => ( ord_less_eq @ A @ W @ Z5 ) ) )
           => ( ord_less_eq @ A @ Y4 @ Z5 ) ) ) ) ).

% dense_le_bounded
thf(fact_168_dense__ge__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Z5: A,X: A,Y4: A] :
          ( ( ord_less @ A @ Z5 @ X )
         => ( ! [W: A] :
                ( ( ord_less @ A @ Z5 @ W )
               => ( ( ord_less @ A @ W @ X )
                 => ( ord_less_eq @ A @ Y4 @ W ) ) )
           => ( ord_less_eq @ A @ Y4 @ Z5 ) ) ) ) ).

% dense_ge_bounded
thf(fact_169_dual__order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ B )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans2
thf(fact_170_dual__order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less @ A @ C @ B )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans1
thf(fact_171_order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [A3: A,B4: A] :
              ( ( ord_less_eq @ A @ A3 @ B4 )
              & ( A3 != B4 ) ) ) ) ) ).

% order.strict_iff_order
thf(fact_172_order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [A3: A,B4: A] :
              ( ( ord_less @ A @ A3 @ B4 )
              | ( A3 = B4 ) ) ) ) ) ).

% order.order_iff_strict
thf(fact_173_order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans2
thf(fact_174_order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less @ A @ B @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans1
thf(fact_175_not__le__imp__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Y4: A,X: A] :
          ( ~ ( ord_less_eq @ A @ Y4 @ X )
         => ( ord_less @ A @ X @ Y4 ) ) ) ).

% not_le_imp_less
thf(fact_176_less__le__not__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ( ( ord_less @ A )
        = ( ^ [X3: A,Y2: A] :
              ( ( ord_less_eq @ A @ X3 @ Y2 )
              & ~ ( ord_less_eq @ A @ Y2 @ X3 ) ) ) ) ) ).

% less_le_not_le
thf(fact_177_le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less @ A @ X @ Y4 )
            | ( X = Y4 ) ) ) ) ).

% le_imp_less_or_eq
thf(fact_178_le__less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
          | ( ord_less @ A @ Y4 @ X ) ) ) ).

% le_less_linear
thf(fact_179_dense__le,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Y4: A,Z5: A] :
          ( ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Y4 )
             => ( ord_less_eq @ A @ X2 @ Z5 ) )
         => ( ord_less_eq @ A @ Y4 @ Z5 ) ) ) ).

% dense_le
thf(fact_180_dense__ge,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Z5: A,Y4: A] :
          ( ! [X2: A] :
              ( ( ord_less @ A @ Z5 @ X2 )
             => ( ord_less_eq @ A @ Y4 @ X2 ) )
         => ( ord_less_eq @ A @ Y4 @ Z5 ) ) ) ).

% dense_ge
thf(fact_181_less__le__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A,Z5: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ Z5 )
           => ( ord_less @ A @ X @ Z5 ) ) ) ) ).

% less_le_trans
thf(fact_182_le__less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A,Z5: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less @ A @ Y4 @ Z5 )
           => ( ord_less @ A @ X @ Z5 ) ) ) ) ).

% le_less_trans
thf(fact_183_less__imp__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ord_less_eq @ A @ X @ Y4 ) ) ) ).

% less_imp_le
thf(fact_184_antisym__conv2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ~ ( ord_less @ A @ X @ Y4 ) )
            = ( X = Y4 ) ) ) ) ).

% antisym_conv2
thf(fact_185_antisym__conv1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X: A,Y4: A] :
          ( ~ ( ord_less @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ X @ Y4 )
            = ( X = Y4 ) ) ) ) ).

% antisym_conv1
thf(fact_186_le__neq__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( A2 != B )
           => ( ord_less @ A @ A2 @ B ) ) ) ) ).

% le_neq_trans
thf(fact_187_not__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ~ ( ord_less @ A @ X @ Y4 ) )
          = ( ord_less_eq @ A @ Y4 @ X ) ) ) ).

% not_less
thf(fact_188_not__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ( ~ ( ord_less_eq @ A @ X @ Y4 ) )
          = ( ord_less @ A @ Y4 @ X ) ) ) ).

% not_le
thf(fact_189_order__less__le__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 )
        & ( order @ A ) )
     => ! [A2: A,B: A,F: A > C2,C: C2] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less_eq @ C2 @ ( F @ B ) @ C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less @ A @ X2 @ Y )
                 => ( ord_less @ C2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_less_le_subst2
thf(fact_190_order__less__le__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 )
        & ( order @ A ) )
     => ! [A2: A,F: B2 > A,B: B2,C: B2] :
          ( ( ord_less @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less_eq @ B2 @ B @ C )
           => ( ! [X2: B2,Y: B2] :
                  ( ( ord_less_eq @ B2 @ X2 @ Y )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_191_order__le__less__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 )
        & ( order @ A ) )
     => ! [A2: A,B: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less @ C2 @ ( F @ B ) @ C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y )
                 => ( ord_less_eq @ C2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_le_less_subst2
thf(fact_192_order__le__less__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 )
        & ( order @ A ) )
     => ! [A2: A,F: B2 > A,B: B2,C: B2] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less @ B2 @ B @ C )
           => ( ! [X2: B2,Y: B2] :
                  ( ( ord_less @ B2 @ X2 @ Y )
                 => ( ord_less @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_193_less__le,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [X3: A,Y2: A] :
              ( ( ord_less_eq @ A @ X3 @ Y2 )
              & ( X3 != Y2 ) ) ) ) ) ).

% less_le
thf(fact_194_le__less,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [X3: A,Y2: A] :
              ( ( ord_less @ A @ X3 @ Y2 )
              | ( X3 = Y2 ) ) ) ) ) ).

% le_less
thf(fact_195_leI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y4: A] :
          ( ~ ( ord_less @ A @ X @ Y4 )
         => ( ord_less_eq @ A @ Y4 @ X ) ) ) ).

% leI
thf(fact_196_leD,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y4: A,X: A] :
          ( ( ord_less_eq @ A @ Y4 @ X )
         => ~ ( ord_less @ A @ X @ Y4 ) ) ) ).

% leD
thf(fact_197_complete__interval,axiom,
    ! [A: $tType] :
      ( ( condit1037483654norder @ A )
     => ! [A2: A,B: A,P3: A > $o] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( P3 @ A2 )
           => ( ~ ( P3 @ B )
             => ? [C3: A] :
                  ( ( ord_less_eq @ A @ A2 @ C3 )
                  & ( ord_less_eq @ A @ C3 @ B )
                  & ! [X4: A] :
                      ( ( ( ord_less_eq @ A @ A2 @ X4 )
                        & ( ord_less @ A @ X4 @ C3 ) )
                     => ( P3 @ X4 ) )
                  & ! [D3: A] :
                      ( ! [X2: A] :
                          ( ( ( ord_less_eq @ A @ A2 @ X2 )
                            & ( ord_less @ A @ X2 @ D3 ) )
                         => ( P3 @ X2 ) )
                     => ( ord_less_eq @ A @ D3 @ C3 ) ) ) ) ) ) ) ).

% complete_interval
thf(fact_198_rsquarefree__def,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ( ( rsquarefree @ A )
        = ( ^ [P2: poly @ A] :
              ( ( P2
               != ( zero_zero @ ( poly @ A ) ) )
              & ! [A3: A] :
                  ( ( ( order2 @ A @ A3 @ P2 )
                    = ( zero_zero @ nat ) )
                  | ( ( order2 @ A @ A3 @ P2 )
                    = ( one_one @ nat ) ) ) ) ) ) ) ).

% rsquarefree_def
thf(fact_199_poly__cutoff__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [N: nat] :
          ( ( ( N
              = ( zero_zero @ nat ) )
           => ( ( poly_cutoff @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( zero_zero @ ( poly @ A ) ) ) )
          & ( ( N
             != ( zero_zero @ nat ) )
           => ( ( poly_cutoff @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( one_one @ ( poly @ A ) ) ) ) ) ) ).

% poly_cutoff_1
thf(fact_200_coeff__0__reflect__poly__0__iff,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( ( coeff @ A @ ( reflect_poly @ A @ P ) @ ( zero_zero @ nat ) )
            = ( zero_zero @ A ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% coeff_0_reflect_poly_0_iff
thf(fact_201_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( semiring_1_of_nat @ A @ N ) )
          = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% of_nat_0_less_iff
thf(fact_202_order__pderiv,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [P: poly @ A,A2: A] :
          ( ( ( pderiv @ A @ P )
           != ( zero_zero @ ( poly @ A ) ) )
         => ( ( ( order2 @ A @ A2 @ P )
             != ( zero_zero @ nat ) )
           => ( ( order2 @ A @ A2 @ P )
              = ( suc @ ( order2 @ A @ A2 @ ( pderiv @ A @ P ) ) ) ) ) ) ) ).

% order_pderiv
thf(fact_203_order__pderiv2,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [P: poly @ A,A2: A,N: nat] :
          ( ( ( pderiv @ A @ P )
           != ( zero_zero @ ( poly @ A ) ) )
         => ( ( ( order2 @ A @ A2 @ P )
             != ( zero_zero @ nat ) )
           => ( ( ( order2 @ A @ A2 @ ( pderiv @ A @ P ) )
                = N )
              = ( ( order2 @ A @ A2 @ P )
                = ( suc @ N ) ) ) ) ) ) ).

% order_pderiv2
thf(fact_204_cross__def,axiom,
    ( sturm_424270202_cross
    = ( ^ [P2: poly @ real,A3: real,B4: real] : ( sturm_1771227917iation @ ( poly2 @ real @ P2 @ A3 ) @ ( poly2 @ real @ P2 @ B4 ) ) ) ) ).

% cross_def
thf(fact_205_nat_Oinject,axiom,
    ! [X22: nat,Y22: nat] :
      ( ( ( suc @ X22 )
        = ( suc @ Y22 ) )
      = ( X22 = Y22 ) ) ).

% nat.inject
thf(fact_206_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_207_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [M: nat,N: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( semiring_1_of_nat @ A @ N ) )
          = ( M = N ) ) ) ).

% of_nat_eq_iff
thf(fact_208_lessI,axiom,
    ! [N: nat] : ( ord_less @ nat @ N @ ( suc @ N ) ) ).

% lessI
thf(fact_209_Suc__mono,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N ) ) ) ).

% Suc_mono
thf(fact_210_Suc__less__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% Suc_less_eq
thf(fact_211_Suc__le__mono,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_eq @ nat @ ( suc @ N ) @ ( suc @ M ) )
      = ( ord_less_eq @ nat @ N @ M ) ) ).

% Suc_le_mono
thf(fact_212_pderiv__of__nat,axiom,
    ! [A: $tType] :
      ( ( ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ! [N: nat] :
          ( ( pderiv @ A @ ( semiring_1_of_nat @ ( poly @ A ) @ N ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% pderiv_of_nat
thf(fact_213_reflect__poly__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ( ( reflect_poly @ A @ ( one_one @ ( poly @ A ) ) )
        = ( one_one @ ( poly @ A ) ) ) ) ).

% reflect_poly_1
thf(fact_214_of__nat__0,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A )
     => ( ( semiring_1_of_nat @ A @ ( zero_zero @ nat ) )
        = ( zero_zero @ A ) ) ) ).

% of_nat_0
thf(fact_215_of__nat__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [N: nat] :
          ( ( ( zero_zero @ A )
            = ( semiring_1_of_nat @ A @ N ) )
          = ( ( zero_zero @ nat )
            = N ) ) ) ).

% of_nat_0_eq_iff
thf(fact_216_of__nat__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [M: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( zero_zero @ A ) )
          = ( M
            = ( zero_zero @ nat ) ) ) ) ).

% of_nat_eq_0_iff
thf(fact_217_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat,N: nat] :
          ( ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) )
          = ( ord_less @ nat @ M @ N ) ) ) ).

% of_nat_less_iff
thf(fact_218_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat,N: nat] :
          ( ( ord_less_eq @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) )
          = ( ord_less_eq @ nat @ M @ N ) ) ) ).

% of_nat_le_iff
thf(fact_219_less__Suc0,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ N @ ( suc @ ( zero_zero @ nat ) ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% less_Suc0
thf(fact_220_zero__less__Suc,axiom,
    ! [N: nat] : ( ord_less @ nat @ ( zero_zero @ nat ) @ ( suc @ N ) ) ).

% zero_less_Suc
thf(fact_221_of__nat__1,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A )
     => ( ( semiring_1_of_nat @ A @ ( one_one @ nat ) )
        = ( one_one @ A ) ) ) ).

% of_nat_1
thf(fact_222_of__nat__1__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [N: nat] :
          ( ( ( one_one @ A )
            = ( semiring_1_of_nat @ A @ N ) )
          = ( N
            = ( one_one @ nat ) ) ) ) ).

% of_nat_1_eq_iff
thf(fact_223_of__nat__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [N: nat] :
          ( ( ( semiring_1_of_nat @ A @ N )
            = ( one_one @ A ) )
          = ( N
            = ( one_one @ nat ) ) ) ) ).

% of_nat_eq_1_iff
thf(fact_224_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ N @ ( one_one @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% less_one
thf(fact_225_coeff__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( coeff @ A @ ( zero_zero @ ( poly @ A ) ) @ N )
          = ( zero_zero @ A ) ) ) ).

% coeff_0
thf(fact_226_poly__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [X: A] :
          ( ( poly2 @ A @ ( one_one @ ( poly @ A ) ) @ X )
          = ( one_one @ A ) ) ) ).

% poly_1
thf(fact_227_variation__0_I2_J,axiom,
    ! [X: real] :
      ( ( sturm_1771227917iation @ X @ ( zero_zero @ real ) )
      = ( zero_zero @ int ) ) ).

% variation_0(2)
thf(fact_228_variation__0_I1_J,axiom,
    ! [Y4: real] :
      ( ( sturm_1771227917iation @ ( zero_zero @ real ) @ Y4 )
      = ( zero_zero @ int ) ) ).

% variation_0(1)
thf(fact_229_pderiv__1,axiom,
    ! [A: $tType] :
      ( ( ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ( ( pderiv @ A @ ( one_one @ ( poly @ A ) ) )
        = ( zero_zero @ ( poly @ A ) ) ) ) ).

% pderiv_1
thf(fact_230_order__1__eq__0,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ! [X: A] :
          ( ( order2 @ A @ X @ ( one_one @ ( poly @ A ) ) )
          = ( zero_zero @ nat ) ) ) ).

% order_1_eq_0
thf(fact_231_of__nat__le__0__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat] :
          ( ( ord_less_eq @ A @ ( semiring_1_of_nat @ A @ M ) @ ( zero_zero @ A ) )
          = ( M
            = ( zero_zero @ nat ) ) ) ) ).

% of_nat_le_0_iff
thf(fact_232_reflect__poly__reflect__poly,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( ( coeff @ A @ P @ ( zero_zero @ nat ) )
           != ( zero_zero @ A ) )
         => ( ( reflect_poly @ A @ ( reflect_poly @ A @ P ) )
            = P ) ) ) ).

% reflect_poly_reflect_poly
thf(fact_233_One__nat__def,axiom,
    ( ( one_one @ nat )
    = ( suc @ ( zero_zero @ nat ) ) ) ).

% One_nat_def
thf(fact_234_less__fun__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 )
     => ( ( ord_less @ ( A > B2 ) )
        = ( ^ [F2: A > B2,G2: A > B2] :
              ( ( ord_less_eq @ ( A > B2 ) @ F2 @ G2 )
              & ~ ( ord_less_eq @ ( A > B2 ) @ G2 @ F2 ) ) ) ) ) ).

% less_fun_def
thf(fact_235_of__nat__neq__0,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [N: nat] :
          ( ( semiring_1_of_nat @ A @ ( suc @ N ) )
         != ( zero_zero @ A ) ) ) ).

% of_nat_neq_0
thf(fact_236_transitive__stepwise__le,axiom,
    ! [M: nat,N: nat,R: nat > nat > $o] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ! [X2: nat] : ( R @ X2 @ X2 )
       => ( ! [X2: nat,Y: nat,Z3: nat] :
              ( ( R @ X2 @ Y )
             => ( ( R @ Y @ Z3 )
               => ( R @ X2 @ Z3 ) ) )
         => ( ! [N3: nat] : ( R @ N3 @ ( suc @ N3 ) )
           => ( R @ M @ N ) ) ) ) ) ).

% transitive_stepwise_le
thf(fact_237_nat__induct__at__least,axiom,
    ! [M: nat,N: nat,P3: nat > $o] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( P3 @ M )
       => ( ! [N3: nat] :
              ( ( ord_less_eq @ nat @ M @ N3 )
             => ( ( P3 @ N3 )
               => ( P3 @ ( suc @ N3 ) ) ) )
         => ( P3 @ N ) ) ) ) ).

% nat_induct_at_least
thf(fact_238_Nat_Oex__has__greatest__nat,axiom,
    ! [P3: nat > $o,K2: nat,B: nat] :
      ( ( P3 @ K2 )
     => ( ! [Y: nat] :
            ( ( P3 @ Y )
           => ( ord_less_eq @ nat @ Y @ B ) )
       => ? [X2: nat] :
            ( ( P3 @ X2 )
            & ! [Y3: nat] :
                ( ( P3 @ Y3 )
               => ( ord_less_eq @ nat @ Y3 @ X2 ) ) ) ) ) ).

% Nat.ex_has_greatest_nat
thf(fact_239_verit__la__generic,axiom,
    ! [A2: int,X: int] :
      ( ( ord_less_eq @ int @ A2 @ X )
      | ( A2 = X )
      | ( ord_less_eq @ int @ X @ A2 ) ) ).

% verit_la_generic
thf(fact_240_full__nat__induct,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M3: nat] :
              ( ( ord_less_eq @ nat @ ( suc @ M3 ) @ N3 )
             => ( P3 @ M3 ) )
         => ( P3 @ N3 ) )
     => ( P3 @ N ) ) ).

% full_nat_induct
thf(fact_241_not__less__eq__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ~ ( ord_less_eq @ nat @ M @ N ) )
      = ( ord_less_eq @ nat @ ( suc @ N ) @ M ) ) ).

% not_less_eq_eq
thf(fact_242_Suc__n__not__le__n,axiom,
    ! [N: nat] :
      ~ ( ord_less_eq @ nat @ ( suc @ N ) @ N ) ).

% Suc_n_not_le_n
thf(fact_243_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_244_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_245_le__Suc__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ ( suc @ N ) )
      = ( ( ord_less_eq @ nat @ M @ N )
        | ( M
          = ( suc @ N ) ) ) ) ).

% le_Suc_eq
thf(fact_246_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_247_le__trans,axiom,
    ! [I: nat,J: nat,K2: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K2 )
       => ( ord_less_eq @ nat @ I @ K2 ) ) ) ).

% le_trans
thf(fact_248_Suc__le__D,axiom,
    ! [N: nat,M4: nat] :
      ( ( ord_less_eq @ nat @ ( suc @ N ) @ M4 )
     => ? [M5: nat] :
          ( M4
          = ( suc @ M5 ) ) ) ).

% Suc_le_D
thf(fact_249_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_250_le__SucI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ord_less_eq @ nat @ M @ ( suc @ N ) ) ) ).

% le_SucI
thf(fact_251_le__SucE,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ ( suc @ N ) )
     => ( ~ ( ord_less_eq @ nat @ M @ N )
       => ( M
          = ( suc @ N ) ) ) ) ).

% le_SucE

% Type constructors (87)
thf(tcon_Polynomial_Opoly___Rings_Olinordered__idom,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( linordered_idom @ ( poly @ A7 ) ) ) ).

thf(tcon_Real_Oreal___Rings_Olinordered__idom_1,axiom,
    linordered_idom @ real ).

thf(tcon_Int_Oint___Rings_Olinordered__idom_2,axiom,
    linordered_idom @ int ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 )
     => ( preorder @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 )
     => ( order @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 )
     => ( ord @ ( A7 > A8 ) ) ) ).

thf(tcon_Int_Oint___Conditionally__Complete__Lattices_Oconditionally__complete__linorder,axiom,
    condit1037483654norder @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__nonzero__semiring,axiom,
    linord1659791738miring @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__no__zero__divisors,axiom,
    semiri1193490041visors @ int ).

thf(tcon_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0 @ int ).

thf(tcon_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ int ).

thf(tcon_Int_Oint___Orderings_Opreorder_3,axiom,
    preorder @ int ).

thf(tcon_Int_Oint___Orderings_Olinorder,axiom,
    linorder @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__ring__1,axiom,
    comm_ring_1 @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1 @ int ).

thf(tcon_Int_Oint___Orderings_Ono__top,axiom,
    no_top @ int ).

thf(tcon_Int_Oint___Orderings_Ono__bot,axiom,
    no_bot @ int ).

thf(tcon_Int_Oint___Orderings_Oorder_4,axiom,
    order @ int ).

thf(tcon_Int_Oint___Nat_Oring__char__0,axiom,
    ring_char_0 @ int ).

thf(tcon_Int_Oint___Orderings_Oord_5,axiom,
    ord @ int ).

thf(tcon_Int_Oint___Groups_Ozero,axiom,
    zero @ int ).

thf(tcon_Int_Oint___Rings_Oidom,axiom,
    idom @ int ).

thf(tcon_Int_Oint___Groups_Oone,axiom,
    one @ int ).

thf(tcon_Nat_Onat___Conditionally__Complete__Lattices_Oconditionally__complete__linorder_6,axiom,
    condit1037483654norder @ nat ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Olinordered__nonzero__semiring_7,axiom,
    linord1659791738miring @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors_8,axiom,
    semiri1193490041visors @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1_9,axiom,
    comm_semiring_1 @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__0_10,axiom,
    comm_semiring_0 @ nat ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0_11,axiom,
    semiring_char_0 @ nat ).

thf(tcon_Nat_Onat___Orderings_Opreorder_12,axiom,
    preorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Olinorder_13,axiom,
    linorder @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__1_14,axiom,
    semiring_1 @ nat ).

thf(tcon_Nat_Onat___Orderings_Ono__top_15,axiom,
    no_top @ nat ).

thf(tcon_Nat_Onat___Orderings_Oorder_16,axiom,
    order @ nat ).

thf(tcon_Nat_Onat___Orderings_Oord_17,axiom,
    ord @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero_18,axiom,
    zero @ nat ).

thf(tcon_Nat_Onat___Groups_Oone_19,axiom,
    one @ nat ).

thf(tcon_Set_Oset___Orderings_Opreorder_20,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_21,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_22,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_23,axiom,
    preorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Olinorder_24,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Oorder_25,axiom,
    order @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_26,axiom,
    ord @ $o ).

thf(tcon_Real_Oreal___Conditionally__Complete__Lattices_Oconditionally__complete__linorder_27,axiom,
    condit1037483654norder @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__nonzero__semiring_28,axiom,
    linord1659791738miring @ real ).

thf(tcon_Real_Oreal___Rings_Osemiring__no__zero__divisors_29,axiom,
    semiri1193490041visors @ real ).

thf(tcon_Real_Oreal___Rings_Oring__no__zero__divisors_30,axiom,
    ring_n68954251visors @ real ).

thf(tcon_Real_Oreal___Orderings_Odense__linorder,axiom,
    dense_linorder @ real ).

thf(tcon_Real_Oreal___Fields_Olinordered__field,axiom,
    linordered_field @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__1_31,axiom,
    comm_semiring_1 @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__0_32,axiom,
    comm_semiring_0 @ real ).

thf(tcon_Real_Oreal___Orderings_Odense__order,axiom,
    dense_order @ real ).

thf(tcon_Real_Oreal___Nat_Osemiring__char__0_33,axiom,
    semiring_char_0 @ real ).

thf(tcon_Real_Oreal___Fields_Ofield__char__0,axiom,
    field_char_0 @ real ).

thf(tcon_Real_Oreal___Orderings_Opreorder_34,axiom,
    preorder @ real ).

thf(tcon_Real_Oreal___Orderings_Olinorder_35,axiom,
    linorder @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__ring__1_36,axiom,
    comm_ring_1 @ real ).

thf(tcon_Real_Oreal___Rings_Osemiring__1_37,axiom,
    semiring_1 @ real ).

thf(tcon_Real_Oreal___Orderings_Ono__top_38,axiom,
    no_top @ real ).

thf(tcon_Real_Oreal___Orderings_Ono__bot_39,axiom,
    no_bot @ real ).

thf(tcon_Real_Oreal___Orderings_Oorder_40,axiom,
    order @ real ).

thf(tcon_Real_Oreal___Nat_Oring__char__0_41,axiom,
    ring_char_0 @ real ).

thf(tcon_Real_Oreal___Orderings_Oord_42,axiom,
    ord @ real ).

thf(tcon_Real_Oreal___Groups_Ozero_43,axiom,
    zero @ real ).

thf(tcon_Real_Oreal___Rings_Oidom_44,axiom,
    idom @ real ).

thf(tcon_Real_Oreal___Groups_Oone_45,axiom,
    one @ real ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__nonzero__semiring_46,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( linord1659791738miring @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Osemiring__no__zero__divisors_47,axiom,
    ! [A7: $tType] :
      ( ( ( comm_semiring_0 @ A7 )
        & ( semiri1193490041visors @ A7 ) )
     => ( semiri1193490041visors @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oring__no__zero__divisors_48,axiom,
    ! [A7: $tType] :
      ( ( idom @ A7 )
     => ( ring_n68954251visors @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__1_49,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_1 @ A7 )
     => ( comm_semiring_1 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__0_50,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_0 @ A7 )
     => ( comm_semiring_0 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Nat_Osemiring__char__0_51,axiom,
    ! [A7: $tType] :
      ( ( ( ring_char_0 @ A7 )
        & ( comm_ring_1 @ A7 ) )
     => ( semiring_char_0 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Opreorder_52,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( preorder @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Olinorder_53,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( linorder @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__ring__1_54,axiom,
    ! [A7: $tType] :
      ( ( comm_ring_1 @ A7 )
     => ( comm_ring_1 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Osemiring__1_55,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_1 @ A7 )
     => ( semiring_1 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Oorder_56,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( order @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Nat_Oring__char__0_57,axiom,
    ! [A7: $tType] :
      ( ( ( ring_char_0 @ A7 )
        & ( comm_ring_1 @ A7 ) )
     => ( ring_char_0 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Oord_58,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( ord @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ozero_59,axiom,
    ! [A7: $tType] :
      ( ( zero @ A7 )
     => ( zero @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oidom_60,axiom,
    ! [A7: $tType] :
      ( ( idom @ A7 )
     => ( idom @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Oone_61,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_1 @ A7 )
     => ( one @ ( poly @ A7 ) ) ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    ( ( sturm_1700286437_r_pos @ p @ x )
   != ( ~ ( ( ( ( poly2 @ real @ p @ x )
              = ( zero_zero @ real ) )
           => ( sturm_1700286437_r_pos @ ( pderiv @ real @ p ) @ x ) )
          & ( ( ( poly2 @ real @ p @ x )
             != ( zero_zero @ real ) )
           => ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ p @ x ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
